const mysql = require('mysql2/promise');
//const { env } = require('process');

const createConnection = async () => {
	return await mysql.createConnection({
		host: process.env.DB_HOST,
		user: process.env.DB_USER,
		password: process.env.DB_PASS,
		database: process.env.DB_NAME
	});
}

const getReply = async (keyword) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT resposta FROM chatbots WHERE pergunta = ?', [keyword]);
	if (rows.length > 0) return rows[0].resposta;
	if (rows.length = 0) return false;
	return (await createConnection()).end;
}

const getAgendamento = async (dataEnvio) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT * FROM agendamentos WHERE dataEnvio = ? AND statusEnvio != "Enviado" LIMIT 30', [dataEnvio]);
	if (rows.length > 0) return rows;
	return false;
}

const setAgendamento = async (id) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('UPDATE agendamentos SET statusEnvio = "Enviado" WHERE id = ?', [id]);
	if (rows.length > 0) return rows;
	return false;
}

const getChatBot = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT status FROM statuschatbots WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return rows[0].status;
	return false;
}

const setChatBotOff = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('UPDATE statuschatbots SET status = "off" WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return rows;
	return false;
}

const setChatBotOn = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('UPDATE statuschatbots SET status = "ok" WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return rows;
	return false;
}

const setContactChatbot = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('INSERT INTO statuschatbots (`id`, `msgFrom`) VALUES (NULL, ?);', [msgFrom]);
	if (rows.length > 0) return rows;
	return false;
}

const getContactChatbot = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT * FROM statuschatbots WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return true;
	return false;
}

const getDialogFlowAudio = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT status FROM dialogFlowaudios WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return rows[0].status;
	return false;
}

const setDialogOffAudio = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('UPDATE dialogFlowaudios SET status = "off" WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return rows;
	return false;
}

const setDialogOnAudio = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('UPDATE dialogFlowaudios SET status = "ok" WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return rows;
	return false;
}

const getDialogFlow = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT status FROM dialogFlows WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return rows[0].status;
	return false;
}

const setDialogOff = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('UPDATE dialogFlows SET status = "off" WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return rows;
	return false;
}

const setDialogOn = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('UPDATE dialogFlows SET status = "ok" WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return rows;
	return false;
}

const setContactDialog = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('INSERT INTO dialogFlows (`id`, `msgFrom`) VALUES (NULL, ?);', [msgFrom]);
	if (rows.length > 0) return rows;
	return false;
}

const getContactDialog = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT * FROM dialogFlows WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return true;
	return false;
}

const setContactDialogAudio = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('INSERT INTO dialogFlowaudios (`id`, `msgFrom`) VALUES (NULL, ?);', [msgFrom]);
	if (rows.length > 0) return rows;
	return false;
}

const getContactDialogAudio = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT * FROM dialogFlowaudios WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return true;
	return false;
}

const setWhatsAppAgendamento = async (nome, idWhaticket) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('INSERT INTO statuswhatsapps (`id`, `nome`, `idWhaticket`) VALUES (NULL, ?, ?);', [nome, idWhaticket]);
	if (rows.length > 0) return rows;
	return false;
}

const getWhatsAppAgendamento = async (idWhaticket) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT * FROM statuswhatsapps WHERE idWhaticket = ?', [idWhaticket]);
	if (rows.length > 0) return true;
	return false;
}

const getWhatsAppAgendamentoStatus = async (idWhaticket) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT status FROM statuswhatsapps WHERE idWhaticket = ?', [idWhaticket]);
	if (rows.length > 0) return rows[0].status;
	return false;
}

const getWhatsAppAgendamentoControle = async (idWhaticket) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT controle FROM statuswhatsapps WHERE idWhaticket = ?', [idWhaticket]);
	if (rows.length > 0) return rows[0].controle;
	return false;
}

const setWhatsAppAgendamentoControle = async (controle, idWhaticket) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('UPDATE statuswhatsapps SET controle = ? WHERE idWhaticket = ?', [controle, idWhaticket]);
	if (rows.length > 0) return rows;
	return false;
}

const delWhatsAppAgendamentoControle = async (idWhaticket) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('UPDATE statuswhatsapps SET controle = 0 WHERE idWhaticket = ?', [idWhaticket]);
	if (rows.length > 0) return rows;
	return false;
}

const getAppAgendamentoStatus = async () => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT status FROM agstatuswhatsapps');
	if (rows.length > 0) return rows[0].status;
	return false;
}

const getHorarioInicio = async () => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT inicio FROM horariochatbots');
	if (rows.length > 0) return rows[0].inicio;
	return false;
}

const getHorarioTermino = async () => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT termino FROM horariochatbots');
	if (rows.length > 0) return rows[0].termino;
	return false;
}

const getLimiteUsuario = async () => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT * FROM limiteconexoes');
	if (rows.length > 0) return rows[0].user;
	return false;
}

const getLimiteWhatsApp = async () => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT whatsapp FROM limiteconexoes');
	if (rows.length > 0) return rows[0].whatsapp;
	return false;
}

const setProtocolo = async (usuario, protocolo) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('INSERT INTO protocolos (`id`, `usuario`, `protocolo`) VALUES (NULL, ?, ?);', [usuario, protocolo]);
	if (rows.length > 0) return rows;
	return false;
}

const getWhatsAppId = async (ticketid) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT whatsappId FROM Tickets WHERE id = ?', [ticketid]);
	if (rows.length > 0) return rows;
	return false;
}

const deleteWhatsAppId = async (id) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('DELETE FROM statuswhatsapps WHERE idWhaticket = ?', [id]);
	if (rows.length > 0) return rows;
	return false;
}

const getActiveWhatsAppId = async (wppid) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT * FROM Whatsapps WHERE id = ?', [wppid]);
	if (rows.length > 0) return true;
	return false;
}

const getN8N = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT status FROM n8ns WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return rows[0].status;
	return false;
}

const getContactN8N = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT * FROM n8ns WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return true;
	return false;
}

const setContactN8N = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('INSERT INTO n8ns (`id`, `msgFrom`) VALUES (NULL, ?);', [msgFrom]);
	if (rows.length > 0) return rows;
	return false;
}

const setN8NOff = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('UPDATE n8ns SET status = "off" WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return rows;
	return false;
}

const setN8NOn = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('UPDATE n8ns SET status = "ok" WHERE msgFrom = ?', [msgFrom]);
	if (rows.length > 0) return rows;
	return false;
}

const getGrupo = async () => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT status FROM statusgrupos ');
	if (rows.length > 0) return rows[0].status;
	return false;
}

const getTags = async () => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT * FROM tags');
	if (rows.length > 0) return rows;
	return false;
}

const getUserTags = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT tag FROM tagcontacts WHERE usuario = ?', [msgFrom]);
	if (rows.length > 0) return rows[0].tag;
	return false;
}

const setUserTags = async (msgFrom, tags) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('INSERT INTO tagcontacts (`id`, `usuario`, `tag`) VALUES (NULL, ?, ?);', [msgFrom, tags]);
	if (rows.length > 0) return rows;
	return false;
}

const deleteUserTags = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('DELETE FROM tagcontacts WHERE usuario = ?', [msgFrom]);
	if (rows.length > 0) return rows;
	return false;
}

const setContactTag = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('INSERT INTO tagcontacts (`id`, `usuario`) VALUES (NULL, ?);', [msgFrom]);
	if (rows.length > 0) return rows;
	return false;
}

const getContactTag = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT * FROM tagcontacts WHERE usuario = ?', [msgFrom]);
	if (rows.length > 0) return true;
	return false;
}

const getContactId = async (msgFrom) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('SELECT id FROM Contacts WHERE number = ?', [msgFrom]);
	if (rows.length > 0) return rows[0].id;
	return false;
}

const setTicketClosed = async (id) => {
	const connection = await createConnection();
	const [rows] = await connection.execute('UPDATE Tickets SET status = "closed" WHERE contactId = ?', [id]);
	if (rows.length > 0) return rows;
	return false;
}

module.exports = {
	createConnection,
	getReply,
	getAgendamento,
	setAgendamento,
	getDialogFlow,
	setDialogOff,
	setDialogOn,
	getDialogFlowAudio,
	setDialogOffAudio,
	setDialogOnAudio,
	setContactDialog,
	getContactDialog,
	getChatBot,
	setChatBotOn,
	setChatBotOff,
	setContactChatbot,
	getContactChatbot,
	getHorarioInicio,
	getHorarioTermino,
	getLimiteUsuario,
	getLimiteWhatsApp,
	setProtocolo,
	getWhatsAppId,
	deleteWhatsAppId,
	getActiveWhatsAppId,
	setWhatsAppAgendamento,
	getWhatsAppAgendamento,
	getWhatsAppAgendamentoStatus,
	getWhatsAppAgendamentoControle,
	setWhatsAppAgendamentoControle,
	delWhatsAppAgendamentoControle,
	getN8N,
	getContactN8N,
	setContactN8N,
	setN8NOff,
	setN8NOn,
	getAppAgendamentoStatus,
	setContactDialogAudio,
	getContactDialogAudio,
	getGrupo,
	getTags,
	getUserTags,
	setUserTags,
	deleteUserTags,
	setContactTag,
	getContactTag,
	getContactId,
	setTicketClosed
}